/////////////////////////////////////////////////////////////
//	File:		"COptionsState.cpp"
//
//	Author:		Jason Stegner (JS)
//
//	Purpose:	Allows the user to modify game settings
/////////////////////////////////////////////////////////////

#include "COptionsState.h"
#include "CSGD_Direct3D.h"
#include "CSGD_MessageSystem.h"
#include "CSGD_EventSystem.h"
#include "CSGD_FModManager.h"
#include "CSGD_TextureManager.h"
#include "CGame.h"
#include "CMainMenuState.h"
#include "SGD_Math.h"
#include <fstream>
using namespace std;

//////////////////////////////////////////
// Function: "GetInstance"
// Purpose:  Returns the instance of the 
//			 COptionsState class
//////////////////////////////////////////
COptionsState* COptionsState::GetInstance()
{
	static COptionsState instance;
	return &instance;
}

//////////////////////////////////////////
// Function: "COptionsState"
// Purpose:  Constructor
//////////////////////////////////////////
COptionsState::COptionsState(void)
{
	// Set all pointers to NULL
	m_pD3D = NULL;
	m_pTM = NULL;
	m_pFM = NULL;

	// Initialize other variables
	m_bDisplayFPS = true;
	m_bWindowed = false;
	m_fMusicVolume = 0.5f;
	m_fMaxMusicVolume = 1.0f;
	m_nMusicID = -1;
	m_nBarSize = 149;
	m_nDifficulty = MEDIUM;
	m_bIsGamePlay = false;

	m_nSoundVolume = 0;
	m_nDifficultySelections = 0;
	m_nDifficultyID = 0;
	m_nExit = 0;
	m_nOptions = 0;
}

//////////////////////////////////////////
// Function: "~COptionsState"
// Purpose:  Destructor
//////////////////////////////////////////
COptionsState::~COptionsState()
{
}

//////////////////////////////////////////
// Function: "Enter"
// Purpose:  Initializes the class upon
//			 starting to use it
//////////////////////////////////////////
void COptionsState::Enter()
{

	// Initialize all pointers to their appropriate singletons
	m_pD3D = CSGD_Direct3D::GetInstance();
	m_pFM = CSGD_FModManager::GetInstance();
	m_pTM = CSGD_TextureManager::GetInstance();
	//	Initialize the bitmap font

	
	//	Set up the music bar's rect from the image.
	m_rMusicBar.left = 0;	m_rMusicBar.top = 0;	m_rMusicBar.right = 160;	m_rMusicBar.bottom = 36;

	//	Play the music.
	/*if(!m_pFM->IsSoundPlaying(m_nMusicID))
	{
		m_pFM->PlaySoundA(m_nMusicID);
		m_pFM->SetVolume(m_nMusicID, COptionsState::GetInstance()->GetMusicVolume());
	}*/
	

	m_nSelection = 0;	//	Default the selection to 0.

	m_nSoundVolume = m_pTM->LoadTexture("Resources/soundVolume.png");
	m_nDifficultySelections = m_pTM->LoadTexture("Resources/difficultyChoices.png");
	m_nDifficultyID = m_pTM->LoadTexture("Resources/difficulty.png");
	m_nExit = m_pTM->LoadTexture("Resources/exit.png");
	m_nOptions = m_pTM->LoadTexture("Resources/options.png");
	m_nDummyImageID = m_pTM->LoadTexture("Resources/DummyRect.png");

}



//////////////////////////////////////////
// Function: "Exit"
// Purpose:  Cleans up the class for while
//			 it is not being used
//////////////////////////////////////////
void COptionsState::Exit()
{	
	m_pTM->ReleaseTexture(m_nSoundVolume);
	m_pTM->ReleaseTexture(m_nDifficultySelections);
	m_pTM->ReleaseTexture(m_nDifficultyID);
	m_pTM->ReleaseTexture(m_nExit);
	m_pTM->ReleaseTexture(m_nOptions);
	m_pTM->ReleaseTexture(m_nDummyImageID);

	//	Unload assets
	if(m_pD3D)
		m_pD3D = NULL;
	
	if(m_pFM)
		m_pFM = NULL;

	if(m_pTM)
		m_pTM = NULL;


}

//////////////////////////////////////////
// Function: "Input"
// Purpose:  Handles input for the options
//			 based on time
//////////////////////////////////////////
bool COptionsState::Input(float fElapsedTime)
{
	// Set up a DirectInput pointer for getting input
	CSGD_DirectInput* pDI = CSGD_DirectInput::GetInstance();

	//	Quit if the user presses ESC
	if (pDI->GetKey(DIK_ESCAPE))
	{
		// Remove the options state from the vector of states (returning to the main menu)
		CGame::GetInstance()->RemoveState();
	}

	//	Depending on the selection, we can do separate actions.
	//	User can toggle the menu's up and down by incrementing or decrementing the menu position.
	//	User can also change the volume of music and sound effects, as well as toggle the FPS and
	//		fullscreen.
	

	// Block music volume max at 1
	if(GetMusicVolume() > 1)
		SetMusicVolume(1.f);

	// Block music volume min at 0
	if(GetMusicVolume() < 0)
		SetMusicVolume(0.f);

	return true;
}

//////////////////////////////////////////
// Function: "Update"
// Purpose:  Updates the class based on time
//////////////////////////////////////////
void COptionsState::Update(float fElapsedTime)
{
	//	Use linear interpolation to display the music volume.
	fPercent1 = m_fMusicVolume / m_fMaxMusicVolume;
	nLength1 = (int)Lerp(0, (float)m_nBarSize, fPercent1);
	
}

//////////////////////////////////////////
// Function: "Render"
// Purpose:  Draws the options menu
//////////////////////////////////////////
void COptionsState::Render(void)
{
	static CSGD_Direct3D* pD3D = CSGD_Direct3D::GetInstance();
	
	pD3D->SpriteBegin();
	RECT rBarRect;

	m_pTM->DrawTexture(m_nDummyImageID, 0.0, 0.0, 0.0, 5.0f, 5.0f, NULL);

	//	Render the background
	//m_pTM->DrawTexture(m_nBGImage, 0.0f, 0.0f, 1.0f, 2.0f, 2.0f);

		
	//	NOTE: All options will be rendered at a darker color red when not selected, and rendered at 
	//			the standard bright red when it is.
	// Display the music volume
	
	rBarRect.left = 6;	rBarRect.top = 41;	rBarRect.right = 6 + nLength1;	rBarRect.bottom = 66;
	m_pTM->DrawTexture(m_nBarImage, 442, 136, 0.4f, 2.0f, 1.0f, &rBarRect, 0, 0, 0, D3DXCOLOR(0, 255, 0, 255));
	m_pTM->DrawTexture(m_nBarImage, 430, 130, 0.4f, 2.0f, 1.0f, &m_rMusicBar);

	//	m_nSoundVolume = m_pTM->LoadTexture("Resources/soundVolume.png");
	//m_nDifficultySelections = m_pTM->LoadTexture("Resources/difficultyChoices.png");
	//m_nDifficultyID = m_pTM->LoadTexture("Resources/difficulty.png");
	//m_nExit = m_pTM->LoadTexture("Resources/exit.png");
	//m_nOptions = m_pTM->LoadTexture("Resources/options.png");
	//m_nDummyImageID = m_pTM->LoadTexture("Resources/DummyRect.png");

	m_pTM->DrawTexture(m_nOptions, 300.0f, 20.0f, 0.0f, 1.0f, 1.0f, NULL);



	pD3D->SpriteEnd();
}
